﻿/*
Run this script to update the MET/CONNECT database from 3.0.0 to 3.1.0

You are recommended to back up your database before running this script

*/
SET NUMERIC_ROUNDABORT OFF
GO
SET ANSI_PADDING, ANSI_WARNINGS, CONCAT_NULL_YIELDS_NULL, ARITHABORT, QUOTED_IDENTIFIER, ANSI_NULLS ON
GO
IF EXISTS (SELECT * FROM tempdb..sysobjects WHERE id=OBJECT_ID('tempdb..#tmpErrors')) DROP TABLE #tmpErrors
GO
CREATE TABLE #tmpErrors (Error int)
GO
SET XACT_ABORT ON
GO
SET TRANSACTION ISOLATION LEVEL SERIALIZABLE
GO

IF NOT EXISTS (SELECT * FROM [dbo].[Version] WHERE cVersion = '2.3.0' )
BEGIN
	RAISERROR(N'*** Database script for version 2.3.0 is missing. ***', 20,-1) WITH LOG
END
GO

IF NOT EXISTS (SELECT * FROM [dbo].[Version] WHERE cVersion = '3.0.0' )
BEGIN
	RAISERROR(N'*** Database script for version 3.0.0 is missing. ***', 20,-1) WITH LOG
END
GO

-- set database compatibility level to SQL Server 2012
DECLARE @comp NVARCHAR(max);
SET @comp = N'ALTER DATABASE [' + (SELECT DB_NAME()) + ']
SET COMPATIBILITY_LEVEL = 110 '
EXEC sp_executesql @comp
GO

-- TEMPORARY, remove for release
DELETE FROM [dbo].[Version] WHERE nVersionUID = '08E5DA6E-DE5E-4CFB-B024-842BDAA19FAA'
GO

-- No need to process if we have a 3.1.0 version record
IF NOT EXISTS (SELECT * FROM [dbo].[Version] WHERE nVersionUID = '08E5DA6E-DE5E-4CFB-B024-842BDAA19FAA' )
BEGIN
	BEGIN TRANSACTION

	-- get the current collation and switch it to case-sensitive
	DECLARE @sql NVARCHAR(max);
	DECLARE @coll_cs NVARCHAR(100);
	SELECT @coll_cs = collation_name FROM sys.databases WHERE name = (SELECT DB_NAME());
	SELECT @coll_cs = REPLACE(@coll_cs, N'CI', N'CS');

	-->>METCON-1416<<--
	UPDATE [dbo].[Servers] SET mNotes = NULL

	IF EXISTS( SELECT * FROM sysobjects WHERE type='P' AND name='splt_GetDatabaseInfo3' )
		BEGIN
			PRINT N'Dropping [dbo].[splt_GetDatabaseInfo3]'

			DROP PROCEDURE [dbo].[splt_GetDatabaseInfo3]

			IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END

	IF OBJECT_ID(N'[dbo].[splt_GetDatabaseInfo3]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[splt_GetDatabaseInfo3]'

		EXEC sp_executesql N'
		CREATE PROCEDURE [dbo].[splt_GetDatabaseInfo3]
        AS
    	BEGIN
			SELECT @@servername AS [instance_name]
		END
		'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF EXISTS( SELECT * FROM sysobjects WHERE type='P' AND name='splt_GetDatabaseInfo4' )
		BEGIN
			PRINT N'Dropping [dbo].[splt_GetDatabaseInfo4]'

			DROP PROCEDURE [dbo].[splt_GetDatabaseInfo4]

			IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END

	IF OBJECT_ID(N'[dbo].[splt_GetDatabaseInfo4]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[splt_GetDatabaseInfo4]'

		EXEC sp_executesql N'
		CREATE PROCEDURE [dbo].[splt_GetDatabaseInfo4]
        AS
    	BEGIN
			SELECT [service_broker_guid] FROM [sys].[databases] WHERE [name] = N''msdb''
		END
		'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF EXISTS( SELECT * FROM sysobjects WHERE type='P' AND name='InsertPoint' )
		BEGIN
			PRINT N'Dropping [dbo].[InsertPoint]'

			DROP PROCEDURE [dbo].[InsertPoint]

			IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END


	-->>METCON-1391<<--
	IF OBJECT_ID(N'[dbo].[InsertPoint]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[InsertPoint]'

		EXEC sp_executesql N'
		CREATE PROCEDURE [dbo].[InsertPoint]
			 @nPointUID [uniqueidentifier]
			,@nCallSheetResultUID uniqueidentifier
			,@nManualTemplateRowUID uniqueidentifier  = NULL
			,@nUUTUnitUID uniqueidentifier  = NULL
			,@nUUTFormatUID uniqueidentifier  = NULL
			,@nReferenceUnitUID uniqueidentifier  = NULL
			,@nReferenceFormatUID uniqueidentifier  = NULL
			,@nCardinalPointUnitUID uniqueidentifier  = NULL
			,@nCardinalPointFormatUID uniqueidentifier  = NULL
			,@nCorrectionUnitUID uniqueidentifier  = NULL
			,@nCorrectionFormatUID uniqueidentifier  = NULL
			,@nUUTRangeUnitUID uniqueidentifier  = NULL
			,@nUUTRangeFormatUID uniqueidentifier  = NULL
			,@nSystemAccuracyUnitUID uniqueidentifier  = NULL
			,@nSystemAccuracyFormatUID uniqueidentifier  = NULL
			,@nTemplateItemUID uniqueidentifier  = NULL
			,@nPointOrdinal int  = NULL
			,@tPointDateTime datetime  = NULL
			,@cPointLabel nvarchar(150)  = NULL
			,@cPointStatusFlags nvarchar(50)  = NULL
			,@cPointPassFailStatus nvarchar(50)  = NULL
			,@cFunctionSelectCode nvarchar(50)  = NULL
			,@nUUT float  = NULL
			,@nReference float  = NULL
			,@nCardinalPoint float  = NULL
			,@nCorrection float  = NULL
			,@cPointDescription nvarchar(300)  = NULL
			,@cRemarks nvarchar(300)  = NULL
			,@cOverrideRemarks nvarchar(300)  = NULL
			,@cDesignation nvarchar(10)  = NULL
			,@cTagId nvarchar(50)  = NULL
			,@nUUTRange float  = NULL
			,@nSetTime float  = NULL
			,@cCondition nvarchar(50)  = NULL
			,@nSystemAccuracy float  = NULL
			,@nClaim numeric(18, 0)  = NULL
			,@lAccredited int
			,@lPrinted int
			,@lUUTIsFixed int
			,@lOverride int
			,@lHeader int  = 0
			,@lActive int  = -1
			,@lDeleted int  = 0
			,@lApproved int  = 0
			,@lAdded int  = -1
			,@nAddFacilityUID uniqueidentifier  = ''AB9B7878-B72C-4A72-9273-47030571BE4C''
			,@nAddUserUID uniqueidentifier  = ''ABF8F215-1980-4E47-84DA-305699ECF5D5''
			,@nImportUID uniqueidentifier  = NULL
		AS
		BEGIN
			INSERT INTO [dbo].[Points] (
				 [nPointUID]
				,[nCallSheetResultUID]
				,[nManualTemplateRowUID]
				,[nUUTUnitUID]
				,[nUUTFormatUID]
				,[nReferenceUnitUID]
				,[nReferenceFormatUID]
				,[nCardinalPointUnitUID]
				,[nCardinalPointFormatUID]
				,[nCorrectionUnitUID]
				,[nCorrectionFormatUID]
				,[nUUTRangeUnitUID]
				,[nUUTRangeFormatUID]
				,[nSystemAccuracyUnitUID]
				,[nSystemAccuracyFormatUID]
				,[nTemplateItemUID]
				,[nPointOrdinal]
				,[tPointDateTime]
				,[cPointLabel]
				,[cPointStatusFlags]
				,[cPointPassFailStatus]
				,[cFunctionSelectCode]
				,[nUUT]
				,[nReference]
				,[nCardinalPoint]
				,[nCorrection]
				,[cPointDescription]
				,[cRemarks]
				,[cOverrideRemarks]
				,[cDesignation]
				,[cTagId]
				,[nUUTRange]
				,[nSetTime]
				,[cCondition]
				,[nSystemAccuracy]
				,[nClaim]
				,[lAccredited]
				,[lPrinted]
				,[lUUTIsFixed]
				,[lOverride]
				,[lHeader]
				,[lActive]
				,[lDeleted]
				,[lApproved]
				,[lAdded]
				,[nAddFacilityUID]
				,[nAddUserUID]
				,[nImportUID]
				,[tAddTime]
				,[nUpdateUserUID]
				,[nUpdateFacilityUID]
				,[tUpdateTime]
				,[tMobileTime]
			)
			VALUES (
				 @nPointUID
				,@nCallSheetResultUID
				,@nManualTemplateRowUID
				,@nUUTUnitUID
				,@nUUTFormatUID
				,@nReferenceUnitUID
				,@nReferenceFormatUID
				,@nCardinalPointUnitUID
				,@nCardinalPointFormatUID
				,@nCorrectionUnitUID
				,@nCorrectionFormatUID
				,@nUUTRangeUnitUID
				,@nUUTRangeFormatUID
				,@nSystemAccuracyUnitUID
				,@nSystemAccuracyFormatUID
				,@nTemplateItemUID
				,@nPointOrdinal
				,@tPointDateTime
				,@cPointLabel
				,@cPointStatusFlags
				,@cPointPassFailStatus
				,@cFunctionSelectCode
				,@nUUT
				,@nReference
				,@nCardinalPoint
				,@nCorrection
				,@cPointDescription
				,@cRemarks
				,@cOverrideRemarks
				,@cDesignation
				,@cTagId
				,@nUUTRange
				,@nSetTime
				,@cCondition
				,@nSystemAccuracy
				,@nClaim
				,@lAccredited
				,@lPrinted
				,@lUUTIsFixed
				,@lOverride
				,@lHeader
				,@lActive
				,@lDeleted
				,@lApproved
				,@lAdded
				,@nAddFacilityUID
				,@nAddUserUID
				,@nImportUID
				,GetUTCDate()
				,@nAddUserUID
				,@nAddFacilityUID
				,GetUTCDate()
				,GetUTCDate()
			)
		END
		'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF EXISTS( SELECT * FROM sysobjects WHERE type='P' AND name='InsertPointStatistic' )
		BEGIN
			PRINT N'Dropping [dbo].[InsertPointStatistic]'

			DROP PROCEDURE [dbo].[InsertPointStatistic]

			IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END

	IF OBJECT_ID(N'[dbo].[InsertPointStatistic]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[splt_GetDatabaseInfo4]'

		EXEC sp_executesql N'
		CREATE PROCEDURE [dbo].[InsertPointStatistic]
			 @nPointStatisticUID [uniqueidentifier]
			,@nPointUID uniqueidentifier
			,@nMinimumUUTUnitUID uniqueidentifier  = NULL
			,@nMinimumUUTFormatUID uniqueidentifier  = NULL
			,@nMaximumUUTUnitUID uniqueidentifier  = NULL
			,@nMaximumUUTFormatUID uniqueidentifier  = NULL
			,@nMinimumReferenceUnitUID uniqueidentifier  = NULL
			,@nMinimumReferenceFormatUID uniqueidentifier  = NULL
			,@nMaximumReferenceUnitUID uniqueidentifier  = NULL
			,@nMaximumReferenceFormatUID uniqueidentifier  = NULL
			,@nUUTStandardDeviationUnitUID uniqueidentifier  = NULL
			,@nUUTStandardDeviationFormatUID uniqueidentifier  = NULL
			,@nUUTRawStandardDeviationUnitUID uniqueidentifier  = NULL
			,@nUUTRawStandardDeviationFormatUID uniqueidentifier  = NULL
			,@nReferenceStandardDeviationUnitUID uniqueidentifier  = NULL
			,@nReferenceStandardDeviationFormatUID uniqueidentifier  = NULL
			,@nReference2StandardDeviationUnitUID uniqueidentifier  = NULL
			,@nReference2StandardDeviationFormatUID uniqueidentifier  = NULL
			,@nReferenceRawStandardDeviationUnitUID uniqueidentifier  = NULL
			,@nReferenceRawStandardDeviationFormatUID uniqueidentifier  = NULL
			,@nReferenceRaw2StandardDeviationUnitUID uniqueidentifier  = NULL
			,@nReferenceRaw2StandardDeviationFormatUID uniqueidentifier  = NULL
			,@nSampleRateUnitUID uniqueidentifier  = NULL
			,@nSampleRateFormatUID uniqueidentifier  = NULL
			,@nMinimumUUT float  = NULL
			,@nMaximumUUT float  = NULL
			,@nMinimumReference float  = NULL
			,@nMaximumReference float  = NULL
			,@nUUTStandardDeviation float  = NULL
			,@nUUTRawStandardDeviation float  = NULL
			,@nReferenceStandardDeviation float  = NULL
			,@nReference2StandardDeviation float  = NULL
			,@nReferenceRawStandardDeviation float  = NULL
			,@nReferenceRaw2StandardDeviation float  = NULL
			,@nNumberOfSamplesReference int  = NULL
			,@nNumberOfSamplesUUT int  = 1
			,@nNumberOfSamplesDiscarded int  = 0
			,@nSampleRate float  = NULL
			,@nChiSquared float  = NULL
			,@lNoisy int
			,@lReliable int
			,@lActive int  = -1
			,@lDeleted int  = 0
			,@lApproved int  = 0
			,@lAdded int  = -1
			,@nAddFacilityUID uniqueidentifier  = ''AB9B7878-B72C-4A72-9273-47030571BE4C''
			,@nAddUserUID uniqueidentifier  = ''ABF8F215-1980-4E47-84DA-305699ECF5D5''
			,@nImportUID uniqueidentifier  = NULL
		AS
		BEGIN
			INSERT INTO [dbo].[PointStatistics] (
				 [nPointStatisticUID]
				,[nPointUID]
				,[nMinimumUUTUnitUID]
				,[nMinimumUUTFormatUID]
				,[nMaximumUUTUnitUID]
				,[nMaximumUUTFormatUID]
				,[nMinimumReferenceUnitUID]
				,[nMinimumReferenceFormatUID]
				,[nMaximumReferenceUnitUID]
				,[nMaximumReferenceFormatUID]
				,[nUUTStandardDeviationUnitUID]
				,[nUUTStandardDeviationFormatUID]
				,[nUUTRawStandardDeviationUnitUID]
				,[nUUTRawStandardDeviationFormatUID]
				,[nReferenceStandardDeviationUnitUID]
				,[nReferenceStandardDeviationFormatUID]
				,[nReference2StandardDeviationUnitUID]
				,[nReference2StandardDeviationFormatUID]
				,[nReferenceRawStandardDeviationUnitUID]
				,[nReferenceRawStandardDeviationFormatUID]
				,[nReferenceRaw2StandardDeviationUnitUID]
				,[nReferenceRaw2StandardDeviationFormatUID]
				,[nSampleRateUnitUID]
				,[nSampleRateFormatUID]
				,[nMinimumUUT]
				,[nMaximumUUT]
				,[nMinimumReference]
				,[nMaximumReference]
				,[nUUTStandardDeviation]
				,[nUUTRawStandardDeviation]
				,[nReferenceStandardDeviation]
				,[nReference2StandardDeviation]
				,[nReferenceRawStandardDeviation]
				,[nReferenceRaw2StandardDeviation]
				,[nNumberOfSamplesReference]
				,[nNumberOfSamplesUUT]
				,[nNumberOfSamplesDiscarded]
				,[nSampleRate]
				,[nChiSquared]
				,[lNoisy]
				,[lReliable]
				,[lActive]
				,[lDeleted]
				,[lApproved]
				,[lAdded]
				,[nAddFacilityUID]
				,[nAddUserUID]
				,[nImportUID]
				,[tAddTime]
				,[nUpdateUserUID]
				,[nUpdateFacilityUID]
				,[tUpdateTime]
				,[tMobileTime]
			)
			VALUES (
				 @nPointStatisticUID
				,@nPointUID
				,@nMinimumUUTUnitUID
				,@nMinimumUUTFormatUID
				,@nMaximumUUTUnitUID
				,@nMaximumUUTFormatUID
				,@nMinimumReferenceUnitUID
				,@nMinimumReferenceFormatUID
				,@nMaximumReferenceUnitUID
				,@nMaximumReferenceFormatUID
				,@nUUTStandardDeviationUnitUID
				,@nUUTStandardDeviationFormatUID
				,@nUUTRawStandardDeviationUnitUID
				,@nUUTRawStandardDeviationFormatUID
				,@nReferenceStandardDeviationUnitUID
				,@nReferenceStandardDeviationFormatUID
				,@nReference2StandardDeviationUnitUID
				,@nReference2StandardDeviationFormatUID
				,@nReferenceRawStandardDeviationUnitUID
				,@nReferenceRawStandardDeviationFormatUID
				,@nReferenceRaw2StandardDeviationUnitUID
				,@nReferenceRaw2StandardDeviationFormatUID
				,@nSampleRateUnitUID
				,@nSampleRateFormatUID
				,@nMinimumUUT
				,@nMaximumUUT
				,@nMinimumReference
				,@nMaximumReference
				,@nUUTStandardDeviation
				,@nUUTRawStandardDeviation
				,@nReferenceStandardDeviation
				,@nReference2StandardDeviation
				,@nReferenceRawStandardDeviation
				,@nReferenceRaw2StandardDeviation
				,@nNumberOfSamplesReference
				,@nNumberOfSamplesUUT
				,@nNumberOfSamplesDiscarded
				,@nSampleRate
				,@nChiSquared
				,@lNoisy
				,@lReliable
				,@lActive
				,@lDeleted
				,@lApproved
				,@lAdded
				,@nAddFacilityUID
				,@nAddUserUID
				,@nImportUID
				,GetUTCDate()
				,@nAddUserUID
				,@nAddFacilityUID
				,GetUTCDate()
				,GetUTCDate()
			)
		END
		'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF EXISTS( SELECT * FROM sysobjects WHERE type='P' AND name='InsertPointTolerance' )
		BEGIN
			PRINT N'Dropping [dbo].[InsertPointTolerance]'

			DROP PROCEDURE [dbo].[InsertPointTolerance]

			IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END

	IF OBJECT_ID(N'[dbo].[InsertPointTolerance]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[InsertPointTolerance]'

		EXEC sp_executesql N'
		CREATE PROCEDURE [dbo].[InsertPointTolerance]
			 @nPointToleranceUID [uniqueidentifier]
			,@nPointUID uniqueidentifier
			,@nToleranceUnitUID uniqueidentifier  = NULL
			,@nToleranceFormatUID uniqueidentifier  = NULL
			,@nTolerancePositiveUnitUID uniqueidentifier  = NULL
			,@nTolerancePositiveFormatUID uniqueidentifier  = NULL
			,@nToleranceNegativeUnitUID uniqueidentifier  = NULL
			,@nToleranceNegativeFormatUID uniqueidentifier  = NULL
			,@nReferenceToleranceUnitUID uniqueidentifier  = NULL
			,@nReferenceToleranceFormatUID uniqueidentifier  = NULL
			,@nErrorUnitUID uniqueidentifier  = NULL
			,@nErrorFormatUID uniqueidentifier  = NULL
			,@nToleranceErrorUnitUID uniqueidentifier  = NULL
			,@nToleranceErrorFormatUID uniqueidentifier  = NULL
			,@nTolerance float  = NULL
			,@nTolerancePositive float  = NULL
			,@nToleranceNegative float  = NULL
			,@cToleranceReference nvarchar(50)  = NULL
			,@nReferenceTolerance float  = NULL
			,@nReadingErrorPercent float  = NULL
			,@nReadingErrorReferencePercent float  = NULL
			,@nFullScaleErrorPercent float  = NULL
			,@nFullScaleErrorReferencePercent float  = NULL
			,@nSetErrorPercent float  = NULL
			,@nSetFullScaleErrorPercent float  = NULL
			,@nToleranceErrorPercent float  = NULL
			,@nError float  = NULL
			,@nToleranceError float  = NULL
			,@lActive int  = -1
			,@lDeleted int  = 0
			,@lApproved int  = 0
			,@lAdded int  = -1
			,@nAddFacilityUID uniqueidentifier  = ''AB9B7878-B72C-4A72-9273-47030571BE4C''
			,@nAddUserUID uniqueidentifier  = ''ABF8F215-1980-4E47-84DA-305699ECF5D5''
			,@nImportUID uniqueidentifier  = NULL
		AS
		BEGIN
			INSERT INTO [dbo].[PointTolerances] (
				 [nPointToleranceUID]
				,[nPointUID]
				,[nToleranceUnitUID]
				,[nToleranceFormatUID]
				,[nTolerancePositiveUnitUID]
				,[nTolerancePositiveFormatUID]
				,[nToleranceNegativeUnitUID]
				,[nToleranceNegativeFormatUID]
				,[nReferenceToleranceUnitUID]
				,[nReferenceToleranceFormatUID]
				,[nErrorUnitUID]
				,[nErrorFormatUID]
				,[nToleranceErrorUnitUID]
				,[nToleranceErrorFormatUID]
				,[nTolerance]
				,[nTolerancePositive]
				,[nToleranceNegative]
				,[cToleranceReference]
				,[nReferenceTolerance]
				,[nReadingErrorPercent]
				,[nReadingErrorReferencePercent]
				,[nFullScaleErrorPercent]
				,[nFullScaleErrorReferencePercent]
				,[nSetErrorPercent]
				,[nSetFullScaleErrorPercent]
				,[nToleranceErrorPercent]
				,[nError]
				,[nToleranceError]
				,[lActive]
				,[lDeleted]
				,[lApproved]
				,[lAdded]
				,[nAddFacilityUID]
				,[nAddUserUID]
				,[nImportUID]
				,[tAddTime]
				,[nUpdateUserUID]
				,[nUpdateFacilityUID]
				,[tUpdateTime]
				,[tMobileTime]
			)
			VALUES (
				 @nPointToleranceUID
				,@nPointUID
				,@nToleranceUnitUID
				,@nToleranceFormatUID
				,@nTolerancePositiveUnitUID
				,@nTolerancePositiveFormatUID
				,@nToleranceNegativeUnitUID
				,@nToleranceNegativeFormatUID
				,@nReferenceToleranceUnitUID
				,@nReferenceToleranceFormatUID
				,@nErrorUnitUID
				,@nErrorFormatUID
				,@nToleranceErrorUnitUID
				,@nToleranceErrorFormatUID
				,@nTolerance
				,@nTolerancePositive
				,@nToleranceNegative
				,@cToleranceReference
				,@nReferenceTolerance
				,@nReadingErrorPercent
				,@nReadingErrorReferencePercent
				,@nFullScaleErrorPercent
				,@nFullScaleErrorReferencePercent
				,@nSetErrorPercent
				,@nSetFullScaleErrorPercent
				,@nToleranceErrorPercent
				,@nError
				,@nToleranceError
				,@lActive
				,@lDeleted
				,@lApproved
				,@lAdded
				,@nAddFacilityUID
				,@nAddUserUID
				,@nImportUID
				,GetUTCDate()
				,@nAddUserUID
				,@nAddFacilityUID
				,GetUTCDate()
				,GetUTCDate()
			)
		END
		'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF EXISTS( SELECT * FROM sysobjects WHERE type='P' AND name='InsertPointUncertainty' )
		BEGIN
			PRINT N'Dropping [dbo].[InsertPointUncertainty]'

			DROP PROCEDURE [dbo].[InsertPointUncertainty]

			IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END

	IF OBJECT_ID(N'[dbo].[InsertPointUncertainty]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[InsertPointUncertainty]'

		EXEC sp_executesql N'
		CREATE PROCEDURE [dbo].[InsertPointUncertainty]
		     @nPointUncertaintyUID [uniqueidentifier]
			,@nPointUID uniqueidentifier
			,@nGuardBandLowerUnitUID uniqueidentifier  = NULL
			,@nGuardBandLowerFormatUID uniqueidentifier  = NULL
			,@nGuardBandUpperUnitUID uniqueidentifier  = NULL
			,@nGuardBandUpperFormatUID uniqueidentifier  = NULL
			,@nUncertaintyUnitUID uniqueidentifier  = NULL
			,@nUncertaintyFormatUID uniqueidentifier  = NULL
			,@nUncertaintyExpandedUnitUID uniqueidentifier  = NULL
			,@nUncertaintyExpandedFormatUID uniqueidentifier  = NULL
			,@nUncertaintyDominantUnitUID uniqueidentifier  = NULL
			,@nUncertaintyDominantFormatUID uniqueidentifier  = NULL
			,@nUncertaintyStandardUnitUID uniqueidentifier  = NULL
			,@nUncertaintyStandardFormatUID uniqueidentifier  = NULL
			,@nLowerLimitUnitUID uniqueidentifier  = NULL
			,@nLowerLimitFormatUID uniqueidentifier  = NULL
			,@nUpperLimitUnitUID uniqueidentifier  = NULL
			,@nUpperLimitFormatUID uniqueidentifier  = NULL
			,@nUncertaintyParameter1UnitUID uniqueidentifier  = NULL
			,@nUncertaintyParameter1FormatUID uniqueidentifier  = NULL
			,@nUncertaintyParameter2UnitUID uniqueidentifier  = NULL
			,@nUncertaintyParameter2FormatUID uniqueidentifier  = NULL
			,@nUncertaintyParameter3UnitUID uniqueidentifier  = NULL
			,@nUncertaintyParameter3FormatUID uniqueidentifier  = NULL
			,@nUncertaintyParameter4UnitUID uniqueidentifier  = NULL
			,@nUncertaintyParameter4FormatUID uniqueidentifier  = NULL
			,@nUncertaintyParameter5UnitUID uniqueidentifier  = NULL
			,@nUncertaintyParameter5FormatUID uniqueidentifier  = NULL
			,@nUncertaintyParameter6UnitUID uniqueidentifier  = NULL
			,@nUncertaintyParameter6FormatUID uniqueidentifier  = NULL
			,@nUncertaintyParameter7UnitUID uniqueidentifier  = NULL
			,@nUncertaintyParameter7FormatUID uniqueidentifier  = NULL
			,@nUncertaintyParameter8UnitUID uniqueidentifier  = NULL
			,@nUncertaintyParameter8FormatUID uniqueidentifier  = NULL
			,@nUncertaintyParameter9UnitUID uniqueidentifier  = NULL
			,@nUncertaintyParameter9FormatUID uniqueidentifier  = NULL
			,@nUncertaintyParameter10UnitUID uniqueidentifier  = NULL
			,@nUncertaintyParameter10FormatUID uniqueidentifier  = NULL
			,@nModifier1UnitUID uniqueidentifier  = NULL
			,@nModifier1FormatUID uniqueidentifier  = NULL
			,@nModifier2UnitUID uniqueidentifier  = NULL
			,@nModifier2FormatUID uniqueidentifier  = NULL
			,@nS1UnitUID uniqueidentifier  = NULL
			,@nS1FormatUID uniqueidentifier  = NULL
			,@nS2UnitUID uniqueidentifier  = NULL
			,@nS2FormatUID uniqueidentifier  = NULL
			,@cGuardBandMethod nvarchar(32)  = NULL
			,@nGuardBandLower float  = NULL
			,@nGuardBandUpper float  = NULL
			,@cUncertaintyMethod nvarchar(50)  = NULL
			,@nUncertainty float  = NULL
			,@nUncertaintyExpanded float  = NULL
			,@nUncertaintyDominant float  = NULL
			,@nUncertaintyStandard float  = NULL
			,@nLowerLimit float  = NULL
			,@nUpperLimit float  = NULL
			,@nCoverageFactor float  = NULL
			,@nSystemCoverageFactor float  = NULL
			,@nConfidenceLevel float  = NULL
			,@cStudentsT nvarchar(32)  = NULL
			,@nUncertaintyParameter1 float  = NULL
			,@nUncertaintyParameter2 float  = NULL
			,@nUncertaintyParameter3 float  = NULL
			,@nUncertaintyParameter4 float  = NULL
			,@nUncertaintyParameter5 float  = NULL
			,@nUncertaintyParameter6 float  = NULL
			,@nUncertaintyParameter7 float  = NULL
			,@nUncertaintyParameter8 float  = NULL
			,@nUncertaintyParameter9 float  = NULL
			,@nUncertaintyParameter10 float  = NULL
			,@cSensitivity1 nvarchar(32)  = NULL
			,@cSensitivity2 nvarchar(32)  = NULL
			,@cSensitivity3 nvarchar(32)  = NULL
			,@cSensitivity4 nvarchar(32)  = NULL
			,@cSensitivity5 nvarchar(32)  = NULL
			,@cSensitivity6 nvarchar(32)  = NULL
			,@cSensitivity7 nvarchar(32)  = NULL
			,@cSensitivity8 nvarchar(32)  = NULL
			,@cSensitivity9 nvarchar(32)  = NULL
			,@cSensitivity10 nvarchar(32)  = NULL
			,@cDegreesOfFreedom1 nvarchar(16)  = NULL
			,@cDegreesOfFreedom2 nvarchar(16)  = NULL
			,@cDegreesOfFreedom3 nvarchar(16)  = NULL
			,@cDegreesOfFreedom4 nvarchar(16)  = NULL
			,@cDegreesOfFreedom5 nvarchar(16)  = NULL
			,@cDegreesOfFreedom6 nvarchar(16)  = NULL
			,@cDegreesOfFreedom7 nvarchar(16)  = NULL
			,@cDegreesOfFreedom8 nvarchar(16)  = NULL
			,@cDegreesOfFreedom9 nvarchar(16)  = NULL
			,@cDegreesOfFreedom10 nvarchar(16)  = NULL
			,@nModifier1 float  = NULL
			,@nModifier2 float  = NULL
			,@nS1 float  = NULL
			,@nS2 float  = NULL
			,@cEquilibrationParameters nvarchar(50)  = NULL
			,@lStudentsT int
			,@lDominant int
			,@lWelchSatterthwaite int  = 0
			,@lActive int  = -1
			,@lDeleted int  = 0
			,@lApproved int  = 0
			,@lAdded int  = -1
			,@nAddFacilityUID uniqueidentifier  = ''AB9B7878-B72C-4A72-9273-47030571BE4C''
			,@nAddUserUID uniqueidentifier  = ''ABF8F215-1980-4E47-84DA-305699ECF5D5''
			,@nImportUID uniqueidentifier  = NULL
		AS
		BEGIN
		    INSERT INTO [dbo].[PointUncertainties] (
			 	 [nPointUncertaintyUID]
				,[nPointUID]
				,[nGuardBandLowerUnitUID]
				,[nGuardBandLowerFormatUID]
				,[nGuardBandUpperUnitUID]
				,[nGuardBandUpperFormatUID]
				,[nUncertaintyUnitUID]
				,[nUncertaintyFormatUID]
				,[nUncertaintyExpandedUnitUID]
				,[nUncertaintyExpandedFormatUID]
				,[nUncertaintyDominantUnitUID]
				,[nUncertaintyDominantFormatUID]
				,[nUncertaintyStandardUnitUID]
				,[nUncertaintyStandardFormatUID]
				,[nLowerLimitUnitUID]
				,[nLowerLimitFormatUID]
				,[nUpperLimitUnitUID]
				,[nUpperLimitFormatUID]
				,[nUncertaintyParameter1UnitUID]
				,[nUncertaintyParameter1FormatUID]
				,[nUncertaintyParameter2UnitUID]
				,[nUncertaintyParameter2FormatUID]
				,[nUncertaintyParameter3UnitUID]
				,[nUncertaintyParameter3FormatUID]
				,[nUncertaintyParameter4UnitUID]
				,[nUncertaintyParameter4FormatUID]
				,[nUncertaintyParameter5UnitUID]
				,[nUncertaintyParameter5FormatUID]
				,[nUncertaintyParameter6UnitUID]
				,[nUncertaintyParameter6FormatUID]
				,[nUncertaintyParameter7UnitUID]
				,[nUncertaintyParameter7FormatUID]
				,[nUncertaintyParameter8UnitUID]
				,[nUncertaintyParameter8FormatUID]
				,[nUncertaintyParameter9UnitUID]
				,[nUncertaintyParameter9FormatUID]
				,[nUncertaintyParameter10UnitUID]
				,[nUncertaintyParameter10FormatUID]
				,[nModifier1UnitUID]
				,[nModifier1FormatUID]
				,[nModifier2UnitUID]
				,[nModifier2FormatUID]
				,[nS1UnitUID]
				,[nS1FormatUID]
				,[nS2UnitUID]
				,[nS2FormatUID]
				,[cGuardBandMethod]
				,[nGuardBandLower]
				,[nGuardBandUpper]
				,[cUncertaintyMethod]
				,[nUncertainty]
				,[nUncertaintyExpanded]
				,[nUncertaintyDominant]
				,[nUncertaintyStandard]
				,[nLowerLimit]
				,[nUpperLimit]
				,[nCoverageFactor]
				,[nSystemCoverageFactor]
				,[nConfidenceLevel]
				,[cStudentsT]
				,[nUncertaintyParameter1]
				,[nUncertaintyParameter2]
				,[nUncertaintyParameter3]
				,[nUncertaintyParameter4]
				,[nUncertaintyParameter5]
				,[nUncertaintyParameter6]
				,[nUncertaintyParameter7]
				,[nUncertaintyParameter8]
				,[nUncertaintyParameter9]
				,[nUncertaintyParameter10]
				,[cSensitivity1]
				,[cSensitivity2]
				,[cSensitivity3]
				,[cSensitivity4]
				,[cSensitivity5]
				,[cSensitivity6]
				,[cSensitivity7]
				,[cSensitivity8]
				,[cSensitivity9]
				,[cSensitivity10]
				,[cDegreesOfFreedom1]
				,[cDegreesOfFreedom2]
				,[cDegreesOfFreedom3]
				,[cDegreesOfFreedom4]
				,[cDegreesOfFreedom5]
				,[cDegreesOfFreedom6]
				,[cDegreesOfFreedom7]
				,[cDegreesOfFreedom8]
				,[cDegreesOfFreedom9]
				,[cDegreesOfFreedom10]
				,[nModifier1]
				,[nModifier2]
				,[nS1]
				,[nS2]
				,[cEquilibrationParameters]
				,[lStudentsT]
				,[lDominant]
				,[lWelchSatterthwaite]
				,[lActive]
				,[lDeleted]
				,[lApproved]
				,[lAdded]
				,[nAddFacilityUID]
				,[nAddUserUID]
				,[nImportUID]
				,[tAddTime]
				,[nUpdateUserUID]
				,[nUpdateFacilityUID]
				,[tUpdateTime]
				,[tMobileTime]
			)
			VALUES (
		         @nPointUncertaintyUID
				,@nPointUID
				,@nGuardBandLowerUnitUID
				,@nGuardBandLowerFormatUID
				,@nGuardBandUpperUnitUID
				,@nGuardBandUpperFormatUID
				,@nUncertaintyUnitUID
				,@nUncertaintyFormatUID
				,@nUncertaintyExpandedUnitUID
				,@nUncertaintyExpandedFormatUID
				,@nUncertaintyDominantUnitUID
				,@nUncertaintyDominantFormatUID
				,@nUncertaintyStandardUnitUID
				,@nUncertaintyStandardFormatUID
				,@nLowerLimitUnitUID
				,@nLowerLimitFormatUID
				,@nUpperLimitUnitUID
				,@nUpperLimitFormatUID
				,@nUncertaintyParameter1UnitUID
				,@nUncertaintyParameter1FormatUID
				,@nUncertaintyParameter2UnitUID
				,@nUncertaintyParameter2FormatUID
				,@nUncertaintyParameter3UnitUID
				,@nUncertaintyParameter3FormatUID
				,@nUncertaintyParameter4UnitUID
				,@nUncertaintyParameter4FormatUID
				,@nUncertaintyParameter5UnitUID
				,@nUncertaintyParameter5FormatUID
				,@nUncertaintyParameter6UnitUID
				,@nUncertaintyParameter6FormatUID
				,@nUncertaintyParameter7UnitUID
				,@nUncertaintyParameter7FormatUID
				,@nUncertaintyParameter8UnitUID
				,@nUncertaintyParameter8FormatUID
				,@nUncertaintyParameter9UnitUID
				,@nUncertaintyParameter9FormatUID
				,@nUncertaintyParameter10UnitUID
				,@nUncertaintyParameter10FormatUID
				,@nModifier1UnitUID
				,@nModifier1FormatUID
				,@nModifier2UnitUID
				,@nModifier2FormatUID
				,@nS1UnitUID
				,@nS1FormatUID
				,@nS2UnitUID
				,@nS2FormatUID
				,@cGuardBandMethod
				,@nGuardBandLower
				,@nGuardBandUpper
				,@cUncertaintyMethod
				,@nUncertainty
				,@nUncertaintyExpanded
				,@nUncertaintyDominant
				,@nUncertaintyStandard
				,@nLowerLimit
				,@nUpperLimit
				,@nCoverageFactor
				,@nSystemCoverageFactor
				,@nConfidenceLevel
				,@cStudentsT
				,@nUncertaintyParameter1
				,@nUncertaintyParameter2
				,@nUncertaintyParameter3
				,@nUncertaintyParameter4
				,@nUncertaintyParameter5
				,@nUncertaintyParameter6
				,@nUncertaintyParameter7
				,@nUncertaintyParameter8
				,@nUncertaintyParameter9
				,@nUncertaintyParameter10
				,@cSensitivity1
				,@cSensitivity2
				,@cSensitivity3
				,@cSensitivity4
				,@cSensitivity5
				,@cSensitivity6
				,@cSensitivity7
				,@cSensitivity8
				,@cSensitivity9
				,@cSensitivity10
				,@cDegreesOfFreedom1
				,@cDegreesOfFreedom2
				,@cDegreesOfFreedom3
				,@cDegreesOfFreedom4
				,@cDegreesOfFreedom5
				,@cDegreesOfFreedom6
				,@cDegreesOfFreedom7
				,@cDegreesOfFreedom8
				,@cDegreesOfFreedom9
				,@cDegreesOfFreedom10
				,@nModifier1
				,@nModifier2
				,@nS1
				,@nS2
				,@cEquilibrationParameters
				,@lStudentsT
				,@lDominant
				,@lWelchSatterthwaite
				,@lActive
				,@lDeleted
				,@lApproved
				,@lAdded
				,@nAddFacilityUID
				,@nAddUserUID
				,@nImportUID
				,GetUTCDate()
				,@nAddUserUID
				,@nAddFacilityUID
				,GetUTCDate()
				,GetUTCDate()
			)
		END
		'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF EXISTS( SELECT * FROM sysobjects WHERE type='P' AND name='InsertPointExString' )
		BEGIN
			PRINT N'Dropping [dbo].[InsertPointExString]'

			DROP PROCEDURE [dbo].[InsertPointExString]

			IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END

	IF OBJECT_ID(N'[dbo].[InsertPointExString]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[InsertPointExString]'

		EXEC sp_executesql N'
		CREATE PROCEDURE [dbo].[InsertPointExString]
			 @nPointExStringUID uniqueidentifier
			,@nPointUID uniqueidentifier
			,@cField001 nvarchar(255)  = NULL
			,@cField002 nvarchar(255)  = NULL
			,@cField003 nvarchar(255)  = NULL
			,@cField004 nvarchar(255)  = NULL
			,@cField005 nvarchar(255)  = NULL
			,@cField006 nvarchar(255)  = NULL
			,@cField007 nvarchar(255)  = NULL
			,@cField008 nvarchar(255)  = NULL
			,@cField009 nvarchar(255)  = NULL
			,@cField010 nvarchar(255)  = NULL
			,@cField011 nvarchar(255)  = NULL
			,@cField012 nvarchar(255)  = NULL
			,@cField013 nvarchar(255)  = NULL
			,@cField014 nvarchar(255)  = NULL
			,@cField015 nvarchar(255)  = NULL
			,@cField016 nvarchar(255)  = NULL
			,@cField017 nvarchar(255)  = NULL
			,@cField018 nvarchar(255)  = NULL
			,@cField019 nvarchar(255)  = NULL
			,@cField020 nvarchar(255)  = NULL
			,@cField021 nvarchar(255)  = NULL
			,@cField022 nvarchar(255)  = NULL
			,@cField023 nvarchar(255)  = NULL
			,@cField024 nvarchar(255)  = NULL
			,@cField025 nvarchar(255)  = NULL
			,@cField026 nvarchar(255)  = NULL
			,@cField027 nvarchar(255)  = NULL
			,@cField028 nvarchar(255)  = NULL
			,@cField029 nvarchar(255)  = NULL
			,@cField030 nvarchar(255)  = NULL
			,@cField031 nvarchar(255)  = NULL
			,@cField032 nvarchar(255)  = NULL
			,@cField033 nvarchar(255)  = NULL
			,@cField034 nvarchar(255)  = NULL
			,@cField035 nvarchar(255)  = NULL
			,@cField036 nvarchar(255)  = NULL
			,@cField037 nvarchar(255)  = NULL
			,@cField038 nvarchar(255)  = NULL
			,@cField039 nvarchar(255)  = NULL
			,@cField040 nvarchar(255)  = NULL
			,@cField041 nvarchar(255)  = NULL
			,@cField042 nvarchar(255)  = NULL
			,@cField043 nvarchar(255)  = NULL
			,@cField044 nvarchar(255)  = NULL
			,@cField045 nvarchar(255)  = NULL
			,@cField046 nvarchar(255)  = NULL
			,@cField047 nvarchar(255)  = NULL
			,@cField048 nvarchar(255)  = NULL
			,@cField049 nvarchar(255)  = NULL
			,@cField050 nvarchar(255)  = NULL
			,@cField051 nvarchar(255)  = NULL
			,@cField052 nvarchar(255)  = NULL
			,@cField053 nvarchar(255)  = NULL
			,@cField054 nvarchar(255)  = NULL
			,@cField055 nvarchar(255)  = NULL
			,@cField056 nvarchar(255)  = NULL
			,@cField057 nvarchar(255)  = NULL
			,@cField058 nvarchar(255)  = NULL
			,@cField059 nvarchar(255)  = NULL
			,@cField060 nvarchar(255)  = NULL
			,@lActive int  = -1
			,@lDeleted int  = 0
			,@lApproved int  = 0
			,@lAdded int  = -1
			,@nAddFacilityUID uniqueidentifier  = ''AB9B7878-B72C-4A72-9273-47030571BE4C''
			,@nAddUserUID uniqueidentifier  = ''ABF8F215-1980-4E47-84DA-305699ECF5D5''
			,@nImportUID uniqueidentifier  = NULL
		AS
		BEGIN
			INSERT INTO [dbo].[PointExStrings] (
				 [nPointExStringUID]
				,[nPointUID]
				,[cField001]
				,[cField002]
				,[cField003]
				,[cField004]
				,[cField005]
				,[cField006]
				,[cField007]
				,[cField008]
				,[cField009]
				,[cField010]
				,[cField011]
				,[cField012]
				,[cField013]
				,[cField014]
				,[cField015]
				,[cField016]
				,[cField017]
				,[cField018]
				,[cField019]
				,[cField020]
				,[cField021]
				,[cField022]
				,[cField023]
				,[cField024]
				,[cField025]
				,[cField026]
				,[cField027]
				,[cField028]
				,[cField029]
				,[cField030]
				,[cField031]
				,[cField032]
				,[cField033]
				,[cField034]
				,[cField035]
				,[cField036]
				,[cField037]
				,[cField038]
				,[cField039]
				,[cField040]
				,[cField041]
				,[cField042]
				,[cField043]
				,[cField044]
				,[cField045]
				,[cField046]
				,[cField047]
				,[cField048]
				,[cField049]
				,[cField050]
				,[cField051]
				,[cField052]
				,[cField053]
				,[cField054]
				,[cField055]
				,[cField056]
				,[cField057]
				,[cField058]
				,[cField059]
				,[cField060]
				,[lActive]
				,[lDeleted]
				,[lApproved]
				,[lAdded]
				,[nAddFacilityUID]
				,[nAddUserUID]
				,[nImportUID]
				,[tAddTime]
				,[nUpdateUserUID]
				,[nUpdateFacilityUID]
				,[tUpdateTime]
				,[tMobileTime]
			)
			VALUES (
				 @nPointExStringUID
				,@nPointUID
				,@cField001
				,@cField002
				,@cField003
				,@cField004
				,@cField005
				,@cField006
				,@cField007
				,@cField008
				,@cField009
				,@cField010
				,@cField011
				,@cField012
				,@cField013
				,@cField014
				,@cField015
				,@cField016
				,@cField017
				,@cField018
				,@cField019
				,@cField020
				,@cField021
				,@cField022
				,@cField023
				,@cField024
				,@cField025
				,@cField026
				,@cField027
				,@cField028
				,@cField029
				,@cField030
				,@cField031
				,@cField032
				,@cField033
				,@cField034
				,@cField035
				,@cField036
				,@cField037
				,@cField038
				,@cField039
				,@cField040
				,@cField041
				,@cField042
				,@cField043
				,@cField044
				,@cField045
				,@cField046
				,@cField047
				,@cField048
				,@cField049
				,@cField050
				,@cField051
				,@cField052
				,@cField053
				,@cField054
				,@cField055
				,@cField056
				,@cField057
				,@cField058
				,@cField059
				,@cField060
				,@lActive
				,@lDeleted
				,@lApproved
				,@lAdded
				,@nAddFacilityUID
				,@nAddUserUID
				,@nImportUID
				,GetUTCDate()
				,@nAddUserUID
				,@nAddFacilityUID
				,GetUTCDate()
				,GetUTCDate()
			)
		END
		'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF EXISTS( SELECT * FROM sysobjects WHERE type='P' AND name='InsertPointExLogical' )
		BEGIN
			PRINT N'Dropping [dbo].[InsertPointExLogical]'

			DROP PROCEDURE [dbo].[InsertPointExLogical]

			IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END

	IF OBJECT_ID(N'[dbo].[InsertPointExLogical]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[InsertPointExLogical]'

		EXEC sp_executesql N'
		CREATE PROCEDURE [dbo].[InsertPointExLogical]
			 @nPointExLogicalUID [uniqueidentifier]
			,@nPointUID uniqueidentifier
			,@lField001 int  = NULL
			,@lField002 int  = NULL
			,@lField003 int  = NULL
			,@lField004 int  = NULL
			,@lField005 int  = NULL
			,@lField006 int  = NULL
			,@lField007 int  = NULL
			,@lField008 int  = NULL
			,@lField009 int  = NULL
			,@lField010 int  = NULL
			,@lField011 int  = NULL
			,@lField012 int  = NULL
			,@lField013 int  = NULL
			,@lField014 int  = NULL
			,@lField015 int  = NULL
			,@lField016 int  = NULL
			,@lField017 int  = NULL
			,@lField018 int  = NULL
			,@lField019 int  = NULL
			,@lField020 int  = NULL
			,@lField021 int  = NULL
			,@lField022 int  = NULL
			,@lField023 int  = NULL
			,@lField024 int  = NULL
			,@lField025 int  = NULL
			,@lField026 int  = NULL
			,@lField027 int  = NULL
			,@lField028 int  = NULL
			,@lField029 int  = NULL
			,@lField030 int  = NULL
			,@lField031 int  = NULL
			,@lField032 int  = NULL
			,@lField033 int  = NULL
			,@lField034 int  = NULL
			,@lField035 int  = NULL
			,@lField036 int  = NULL
			,@lField037 int  = NULL
			,@lField038 int  = NULL
			,@lField039 int  = NULL
			,@lField040 int  = NULL
			,@lField041 int  = NULL
			,@lField042 int  = NULL
			,@lField043 int  = NULL
			,@lField044 int  = NULL
			,@lField045 int  = NULL
			,@lField046 int  = NULL
			,@lField047 int  = NULL
			,@lField048 int  = NULL
			,@lField049 int  = NULL
			,@lField050 int  = NULL
			,@lField051 int  = NULL
			,@lField052 int  = NULL
			,@lField053 int  = NULL
			,@lField054 int  = NULL
			,@lField055 int  = NULL
			,@lField056 int  = NULL
			,@lField057 int  = NULL
			,@lField058 int  = NULL
			,@lField059 int  = NULL
			,@lField060 int  = NULL
			,@lActive int  = -1
			,@lDeleted int  = 0
			,@lApproved int  = 0
			,@lAdded int  = -1
			,@nAddFacilityUID uniqueidentifier  = ''AB9B7878-B72C-4A72-9273-47030571BE4C''
			,@nAddUserUID uniqueidentifier  = ''ABF8F215-1980-4E47-84DA-305699ECF5D5''
			,@nImportUID uniqueidentifier  = NULL
		AS
		BEGIN
			INSERT INTO [dbo].[PointExLogicals] (
				 [nPointExLogicalUID]
				,[nPointUID]
				,[lField001]
				,[lField002]
				,[lField003]
				,[lField004]
				,[lField005]
				,[lField006]
				,[lField007]
				,[lField008]
				,[lField009]
				,[lField010]
				,[lField011]
				,[lField012]
				,[lField013]
				,[lField014]
				,[lField015]
				,[lField016]
				,[lField017]
				,[lField018]
				,[lField019]
				,[lField020]
				,[lField021]
				,[lField022]
				,[lField023]
				,[lField024]
				,[lField025]
				,[lField026]
				,[lField027]
				,[lField028]
				,[lField029]
				,[lField030]
				,[lField031]
				,[lField032]
				,[lField033]
				,[lField034]
				,[lField035]
				,[lField036]
				,[lField037]
				,[lField038]
				,[lField039]
				,[lField040]
				,[lField041]
				,[lField042]
				,[lField043]
				,[lField044]
				,[lField045]
				,[lField046]
				,[lField047]
				,[lField048]
				,[lField049]
				,[lField050]
				,[lField051]
				,[lField052]
				,[lField053]
				,[lField054]
				,[lField055]
				,[lField056]
				,[lField057]
				,[lField058]
				,[lField059]
				,[lField060]
				,[lActive]
				,[lDeleted]
				,[lApproved]
				,[lAdded]
				,[nAddFacilityUID]
				,[nAddUserUID]
				,[nImportUID]
				,[tAddTime]
				,[nUpdateUserUID]
				,[nUpdateFacilityUID]
				,[tUpdateTime]
				,[tMobileTime]
			)
			VALUES (
		         @nPointExLogicalUID
				,@nPointUID
				,@lField001
				,@lField002
				,@lField003
				,@lField004
				,@lField005
				,@lField006
				,@lField007
				,@lField008
				,@lField009
				,@lField010
				,@lField011
				,@lField012
				,@lField013
				,@lField014
				,@lField015
				,@lField016
				,@lField017
				,@lField018
				,@lField019
				,@lField020
				,@lField021
				,@lField022
				,@lField023
				,@lField024
				,@lField025
				,@lField026
				,@lField027
				,@lField028
				,@lField029
				,@lField030
				,@lField031
				,@lField032
				,@lField033
				,@lField034
				,@lField035
				,@lField036
				,@lField037
				,@lField038
				,@lField039
				,@lField040
				,@lField041
				,@lField042
				,@lField043
				,@lField044
				,@lField045
				,@lField046
				,@lField047
				,@lField048
				,@lField049
				,@lField050
				,@lField051
				,@lField052
				,@lField053
				,@lField054
				,@lField055
				,@lField056
				,@lField057
				,@lField058
				,@lField059
				,@lField060
				,@lActive
				,@lDeleted
				,@lApproved
				,@lAdded
				,@nAddFacilityUID
				,@nAddUserUID
				,@nImportUID
				,GetUTCDate()
				,@nAddUserUID
				,@nAddFacilityUID
				,GetUTCDate()
				,GetUTCDate()
			)
		END
		'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF EXISTS( SELECT * FROM sysobjects WHERE type='P' AND name='InsertPointExNumeric' )
		BEGIN
			PRINT N'Dropping [dbo].[InsertPointExNumeric]'

			DROP PROCEDURE [dbo].[InsertPointExNumeric]

			IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END

	IF OBJECT_ID(N'[dbo].[InsertPointExNumeric]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[InsertPointExNumeric]'

		EXEC sp_executesql N'
		CREATE PROCEDURE [dbo].[InsertPointExNumeric]
		     @nPointExNumericUID [uniqueidentifier]
			,@nPointUID uniqueidentifier
			,@nField001 float  = NULL
			,@nField001UnitUID uniqueidentifier  = NULL
			,@nField001FormatUID uniqueidentifier  = NULL
			,@nField002 float  = NULL
			,@nField002UnitUID uniqueidentifier  = NULL
			,@nField002FormatUID uniqueidentifier  = NULL
			,@nField003 float  = NULL
			,@nField003UnitUID uniqueidentifier  = NULL
			,@nField003FormatUID uniqueidentifier  = NULL
			,@nField004 float  = NULL
			,@nField004UnitUID uniqueidentifier  = NULL
			,@nField004FormatUID uniqueidentifier  = NULL
			,@nField005 float  = NULL
			,@nField005UnitUID uniqueidentifier  = NULL
			,@nField005FormatUID uniqueidentifier  = NULL
			,@nField006 float  = NULL
			,@nField006UnitUID uniqueidentifier  = NULL
			,@nField006FormatUID uniqueidentifier  = NULL
			,@nField007 float  = NULL
			,@nField007UnitUID uniqueidentifier  = NULL
			,@nField007FormatUID uniqueidentifier  = NULL
			,@nField008 float  = NULL
			,@nField008UnitUID uniqueidentifier  = NULL
			,@nField008FormatUID uniqueidentifier  = NULL
			,@nField009 float  = NULL
			,@nField009UnitUID uniqueidentifier  = NULL
			,@nField009FormatUID uniqueidentifier  = NULL
			,@nField010 float  = NULL
			,@nField010UnitUID uniqueidentifier  = NULL
			,@nField010FormatUID uniqueidentifier  = NULL
			,@nField011 float  = NULL
			,@nField011UnitUID uniqueidentifier  = NULL
			,@nField011FormatUID uniqueidentifier  = NULL
			,@nField012 float  = NULL
			,@nField012UnitUID uniqueidentifier  = NULL
			,@nField012FormatUID uniqueidentifier  = NULL
			,@nField013 float  = NULL
			,@nField013UnitUID uniqueidentifier  = NULL
			,@nField013FormatUID uniqueidentifier  = NULL
			,@nField014 float  = NULL
			,@nField014UnitUID uniqueidentifier  = NULL
			,@nField014FormatUID uniqueidentifier  = NULL
			,@nField015 float  = NULL
			,@nField015UnitUID uniqueidentifier  = NULL
			,@nField015FormatUID uniqueidentifier  = NULL
			,@nField016 float  = NULL
			,@nField016UnitUID uniqueidentifier  = NULL
			,@nField016FormatUID uniqueidentifier  = NULL
			,@nField017 float  = NULL
			,@nField017UnitUID uniqueidentifier  = NULL
			,@nField017FormatUID uniqueidentifier  = NULL
			,@nField018 float  = NULL
			,@nField018UnitUID uniqueidentifier  = NULL
			,@nField018FormatUID uniqueidentifier  = NULL
			,@nField019 float  = NULL
			,@nField019UnitUID uniqueidentifier  = NULL
			,@nField019FormatUID uniqueidentifier  = NULL
			,@nField020 float  = NULL
			,@nField020UnitUID uniqueidentifier  = NULL
			,@nField020FormatUID uniqueidentifier  = NULL
			,@nField021 float  = NULL
			,@nField021UnitUID uniqueidentifier  = NULL
			,@nField021FormatUID uniqueidentifier  = NULL
			,@nField022 float  = NULL
			,@nField022UnitUID uniqueidentifier  = NULL
			,@nField022FormatUID uniqueidentifier  = NULL
			,@nField023 float  = NULL
			,@nField023UnitUID uniqueidentifier  = NULL
			,@nField023FormatUID uniqueidentifier  = NULL
			,@nField024 float  = NULL
			,@nField024UnitUID uniqueidentifier  = NULL
			,@nField024FormatUID uniqueidentifier  = NULL
			,@nField025 float  = NULL
			,@nField025UnitUID uniqueidentifier  = NULL
			,@nField025FormatUID uniqueidentifier  = NULL
			,@nField026 float  = NULL
			,@nField026UnitUID uniqueidentifier  = NULL
			,@nField026FormatUID uniqueidentifier  = NULL
			,@nField027 float  = NULL
			,@nField027UnitUID uniqueidentifier  = NULL
			,@nField027FormatUID uniqueidentifier  = NULL
			,@nField028 float  = NULL
			,@nField028UnitUID uniqueidentifier  = NULL
			,@nField028FormatUID uniqueidentifier  = NULL
			,@nField029 float  = NULL
			,@nField029UnitUID uniqueidentifier  = NULL
			,@nField029FormatUID uniqueidentifier  = NULL
			,@nField030 float  = NULL
			,@nField030UnitUID uniqueidentifier  = NULL
			,@nField030FormatUID uniqueidentifier  = NULL
			,@nField031 float  = NULL
			,@nField031UnitUID uniqueidentifier  = NULL
			,@nField031FormatUID uniqueidentifier  = NULL
			,@nField032 float  = NULL
			,@nField032UnitUID uniqueidentifier  = NULL
			,@nField032FormatUID uniqueidentifier  = NULL
			,@nField033 float  = NULL
			,@nField033UnitUID uniqueidentifier  = NULL
			,@nField033FormatUID uniqueidentifier  = NULL
			,@nField034 float  = NULL
			,@nField034UnitUID uniqueidentifier  = NULL
			,@nField034FormatUID uniqueidentifier  = NULL
			,@nField035 float  = NULL
			,@nField035UnitUID uniqueidentifier  = NULL
			,@nField035FormatUID uniqueidentifier  = NULL
			,@nField036 float  = NULL
			,@nField036UnitUID uniqueidentifier  = NULL
			,@nField036FormatUID uniqueidentifier  = NULL
			,@nField037 float  = NULL
			,@nField037UnitUID uniqueidentifier  = NULL
			,@nField037FormatUID uniqueidentifier  = NULL
			,@nField038 float  = NULL
			,@nField038UnitUID uniqueidentifier  = NULL
			,@nField038FormatUID uniqueidentifier  = NULL
			,@nField039 float  = NULL
			,@nField039UnitUID uniqueidentifier  = NULL
			,@nField039FormatUID uniqueidentifier  = NULL
			,@nField040 float  = NULL
			,@nField040UnitUID uniqueidentifier  = NULL
			,@nField040FormatUID uniqueidentifier  = NULL
			,@nField041 float  = NULL
			,@nField041UnitUID uniqueidentifier  = NULL
			,@nField041FormatUID uniqueidentifier  = NULL
			,@nField042 float  = NULL
			,@nField042UnitUID uniqueidentifier  = NULL
			,@nField042FormatUID uniqueidentifier  = NULL
			,@nField043 float  = NULL
			,@nField043UnitUID uniqueidentifier  = NULL
			,@nField043FormatUID uniqueidentifier  = NULL
			,@nField044 float  = NULL
			,@nField044UnitUID uniqueidentifier  = NULL
			,@nField044FormatUID uniqueidentifier  = NULL
			,@nField045 float  = NULL
			,@nField045UnitUID uniqueidentifier  = NULL
			,@nField045FormatUID uniqueidentifier  = NULL
			,@nField046 float  = NULL
			,@nField046UnitUID uniqueidentifier  = NULL
			,@nField046FormatUID uniqueidentifier  = NULL
			,@nField047 float  = NULL
			,@nField047UnitUID uniqueidentifier  = NULL
			,@nField047FormatUID uniqueidentifier  = NULL
			,@nField048 float  = NULL
			,@nField048UnitUID uniqueidentifier  = NULL
			,@nField048FormatUID uniqueidentifier  = NULL
			,@nField049 float  = NULL
			,@nField049UnitUID uniqueidentifier  = NULL
			,@nField049FormatUID uniqueidentifier  = NULL
			,@nField050 float  = NULL
			,@nField050UnitUID uniqueidentifier  = NULL
			,@nField050FormatUID uniqueidentifier  = NULL
			,@nField051 float  = NULL
			,@nField051UnitUID uniqueidentifier  = NULL
			,@nField051FormatUID uniqueidentifier  = NULL
			,@nField052 float  = NULL
			,@nField052UnitUID uniqueidentifier  = NULL
			,@nField052FormatUID uniqueidentifier  = NULL
			,@nField053 float  = NULL
			,@nField053UnitUID uniqueidentifier  = NULL
			,@nField053FormatUID uniqueidentifier  = NULL
			,@nField054 float  = NULL
			,@nField054UnitUID uniqueidentifier  = NULL
			,@nField054FormatUID uniqueidentifier  = NULL
			,@nField055 float  = NULL
			,@nField055UnitUID uniqueidentifier  = NULL
			,@nField055FormatUID uniqueidentifier  = NULL
			,@nField056 float  = NULL
			,@nField056UnitUID uniqueidentifier  = NULL
			,@nField056FormatUID uniqueidentifier  = NULL
			,@nField057 float  = NULL
			,@nField057UnitUID uniqueidentifier  = NULL
			,@nField057FormatUID uniqueidentifier  = NULL
			,@nField058 float  = NULL
			,@nField058UnitUID uniqueidentifier  = NULL
			,@nField058FormatUID uniqueidentifier  = NULL
			,@nField059 float  = NULL
			,@nField059UnitUID uniqueidentifier  = NULL
			,@nField059FormatUID uniqueidentifier  = NULL
			,@nField060 float  = NULL
			,@nField060UnitUID uniqueidentifier  = NULL
			,@nField060FormatUID uniqueidentifier  = NULL
			,@lActive int  = -1
			,@lDeleted int  = 0
			,@lApproved int  = 0
			,@lAdded int  = -1
			,@nAddFacilityUID uniqueidentifier  = ''AB9B7878-B72C-4A72-9273-47030571BE4C''
			,@nAddUserUID uniqueidentifier  = ''ABF8F215-1980-4E47-84DA-305699ECF5D5''
			,@nImportUID uniqueidentifier  = NULL
		AS
		BEGIN
			INSERT INTO [dbo].[PointExNumerics] (
				 [nPointExNumericUID]
				,[nPointUID]
				,[nField001]
				,[nField001UnitUID]
				,[nField001FormatUID]
				,[nField002]
				,[nField002UnitUID]
				,[nField002FormatUID]
				,[nField003]
				,[nField003UnitUID]
				,[nField003FormatUID]
				,[nField004]
				,[nField004UnitUID]
				,[nField004FormatUID]
				,[nField005]
				,[nField005UnitUID]
				,[nField005FormatUID]
				,[nField006]
				,[nField006UnitUID]
				,[nField006FormatUID]
				,[nField007]
				,[nField007UnitUID]
				,[nField007FormatUID]
				,[nField008]
				,[nField008UnitUID]
				,[nField008FormatUID]
				,[nField009]
				,[nField009UnitUID]
				,[nField009FormatUID]
				,[nField010]
				,[nField010UnitUID]
				,[nField010FormatUID]
				,[nField011]
				,[nField011UnitUID]
				,[nField011FormatUID]
				,[nField012]
				,[nField012UnitUID]
				,[nField012FormatUID]
				,[nField013]
				,[nField013UnitUID]
				,[nField013FormatUID]
				,[nField014]
				,[nField014UnitUID]
				,[nField014FormatUID]
				,[nField015]
				,[nField015UnitUID]
				,[nField015FormatUID]
				,[nField016]
				,[nField016UnitUID]
				,[nField016FormatUID]
				,[nField017]
				,[nField017UnitUID]
				,[nField017FormatUID]
				,[nField018]
				,[nField018UnitUID]
				,[nField018FormatUID]
				,[nField019]
				,[nField019UnitUID]
				,[nField019FormatUID]
				,[nField020]
				,[nField020UnitUID]
				,[nField020FormatUID]
				,[nField021]
				,[nField021UnitUID]
				,[nField021FormatUID]
				,[nField022]
				,[nField022UnitUID]
				,[nField022FormatUID]
				,[nField023]
				,[nField023UnitUID]
				,[nField023FormatUID]
				,[nField024]
				,[nField024UnitUID]
				,[nField024FormatUID]
				,[nField025]
				,[nField025UnitUID]
				,[nField025FormatUID]
				,[nField026]
				,[nField026UnitUID]
				,[nField026FormatUID]
				,[nField027]
				,[nField027UnitUID]
				,[nField027FormatUID]
				,[nField028]
				,[nField028UnitUID]
				,[nField028FormatUID]
				,[nField029]
				,[nField029UnitUID]
				,[nField029FormatUID]
				,[nField030]
				,[nField030UnitUID]
				,[nField030FormatUID]
				,[nField031]
				,[nField031UnitUID]
				,[nField031FormatUID]
				,[nField032]
				,[nField032UnitUID]
				,[nField032FormatUID]
				,[nField033]
				,[nField033UnitUID]
				,[nField033FormatUID]
				,[nField034]
				,[nField034UnitUID]
				,[nField034FormatUID]
				,[nField035]
				,[nField035UnitUID]
				,[nField035FormatUID]
				,[nField036]
				,[nField036UnitUID]
				,[nField036FormatUID]
				,[nField037]
				,[nField037UnitUID]
				,[nField037FormatUID]
				,[nField038]
				,[nField038UnitUID]
				,[nField038FormatUID]
				,[nField039]
				,[nField039UnitUID]
				,[nField039FormatUID]
				,[nField040]
				,[nField040UnitUID]
				,[nField040FormatUID]
				,[nField041]
				,[nField041UnitUID]
				,[nField041FormatUID]
				,[nField042]
				,[nField042UnitUID]
				,[nField042FormatUID]
				,[nField043]
				,[nField043UnitUID]
				,[nField043FormatUID]
				,[nField044]
				,[nField044UnitUID]
				,[nField044FormatUID]
				,[nField045]
				,[nField045UnitUID]
				,[nField045FormatUID]
				,[nField046]
				,[nField046UnitUID]
				,[nField046FormatUID]
				,[nField047]
				,[nField047UnitUID]
				,[nField047FormatUID]
				,[nField048]
				,[nField048UnitUID]
				,[nField048FormatUID]
				,[nField049]
				,[nField049UnitUID]
				,[nField049FormatUID]
				,[nField050]
				,[nField050UnitUID]
				,[nField050FormatUID]
				,[nField051]
				,[nField051UnitUID]
				,[nField051FormatUID]
				,[nField052]
				,[nField052UnitUID]
				,[nField052FormatUID]
				,[nField053]
				,[nField053UnitUID]
				,[nField053FormatUID]
				,[nField054]
				,[nField054UnitUID]
				,[nField054FormatUID]
				,[nField055]
				,[nField055UnitUID]
				,[nField055FormatUID]
				,[nField056]
				,[nField056UnitUID]
				,[nField056FormatUID]
				,[nField057]
				,[nField057UnitUID]
				,[nField057FormatUID]
				,[nField058]
				,[nField058UnitUID]
				,[nField058FormatUID]
				,[nField059]
				,[nField059UnitUID]
				,[nField059FormatUID]
				,[nField060]
				,[nField060UnitUID]
				,[nField060FormatUID]
				,[lActive]
				,[lDeleted]
				,[lApproved]
				,[lAdded]
				,[nAddFacilityUID]
				,[nAddUserUID]
				,[nImportUID]
				,[tAddTime]
				,[nUpdateUserUID]
				,[nUpdateFacilityUID]
				,[tUpdateTime]
				,[tMobileTime]
			)
			VALUES (
				 @nPointExNumericUID
				,@nPointUID
				,@nField001
				,@nField001UnitUID
				,@nField001FormatUID
				,@nField002
				,@nField002UnitUID
				,@nField002FormatUID
				,@nField003
				,@nField003UnitUID
				,@nField003FormatUID
				,@nField004
				,@nField004UnitUID
				,@nField004FormatUID
				,@nField005
				,@nField005UnitUID
				,@nField005FormatUID
				,@nField006
				,@nField006UnitUID
				,@nField006FormatUID
				,@nField007
				,@nField007UnitUID
				,@nField007FormatUID
				,@nField008
				,@nField008UnitUID
				,@nField008FormatUID
				,@nField009
				,@nField009UnitUID
				,@nField009FormatUID
				,@nField010
				,@nField010UnitUID
				,@nField010FormatUID
				,@nField011
				,@nField011UnitUID
				,@nField011FormatUID
				,@nField012
				,@nField012UnitUID
				,@nField012FormatUID
				,@nField013
				,@nField013UnitUID
				,@nField013FormatUID
				,@nField014
				,@nField014UnitUID
				,@nField014FormatUID
				,@nField015
				,@nField015UnitUID
				,@nField015FormatUID
				,@nField016
				,@nField016UnitUID
				,@nField016FormatUID
				,@nField017
				,@nField017UnitUID
				,@nField017FormatUID
				,@nField018
				,@nField018UnitUID
				,@nField018FormatUID
				,@nField019
				,@nField019UnitUID
				,@nField019FormatUID
				,@nField020
				,@nField020UnitUID
				,@nField020FormatUID
				,@nField021
				,@nField021UnitUID
				,@nField021FormatUID
				,@nField022
				,@nField022UnitUID
				,@nField022FormatUID
				,@nField023
				,@nField023UnitUID
				,@nField023FormatUID
				,@nField024
				,@nField024UnitUID
				,@nField024FormatUID
				,@nField025
				,@nField025UnitUID
				,@nField025FormatUID
				,@nField026
				,@nField026UnitUID
				,@nField026FormatUID
				,@nField027
				,@nField027UnitUID
				,@nField027FormatUID
				,@nField028
				,@nField028UnitUID
				,@nField028FormatUID
				,@nField029
				,@nField029UnitUID
				,@nField029FormatUID
				,@nField030
				,@nField030UnitUID
				,@nField030FormatUID
				,@nField031
				,@nField031UnitUID
				,@nField031FormatUID
				,@nField032
				,@nField032UnitUID
				,@nField032FormatUID
				,@nField033
				,@nField033UnitUID
				,@nField033FormatUID
				,@nField034
				,@nField034UnitUID
				,@nField034FormatUID
				,@nField035
				,@nField035UnitUID
				,@nField035FormatUID
				,@nField036
				,@nField036UnitUID
				,@nField036FormatUID
				,@nField037
				,@nField037UnitUID
				,@nField037FormatUID
				,@nField038
				,@nField038UnitUID
				,@nField038FormatUID
				,@nField039
				,@nField039UnitUID
				,@nField039FormatUID
				,@nField040
				,@nField040UnitUID
				,@nField040FormatUID
				,@nField041
				,@nField041UnitUID
				,@nField041FormatUID
				,@nField042
				,@nField042UnitUID
				,@nField042FormatUID
				,@nField043
				,@nField043UnitUID
				,@nField043FormatUID
				,@nField044
				,@nField044UnitUID
				,@nField044FormatUID
				,@nField045
				,@nField045UnitUID
				,@nField045FormatUID
				,@nField046
				,@nField046UnitUID
				,@nField046FormatUID
				,@nField047
				,@nField047UnitUID
				,@nField047FormatUID
				,@nField048
				,@nField048UnitUID
				,@nField048FormatUID
				,@nField049
				,@nField049UnitUID
				,@nField049FormatUID
				,@nField050
				,@nField050UnitUID
				,@nField050FormatUID
				,@nField051
				,@nField051UnitUID
				,@nField051FormatUID
				,@nField052
				,@nField052UnitUID
				,@nField052FormatUID
				,@nField053
				,@nField053UnitUID
				,@nField053FormatUID
				,@nField054
				,@nField054UnitUID
				,@nField054FormatUID
				,@nField055
				,@nField055UnitUID
				,@nField055FormatUID
				,@nField056
				,@nField056UnitUID
				,@nField056FormatUID
				,@nField057
				,@nField057UnitUID
				,@nField057FormatUID
				,@nField058
				,@nField058UnitUID
				,@nField058FormatUID
				,@nField059
				,@nField059UnitUID
				,@nField059FormatUID
				,@nField060
				,@nField060UnitUID
				,@nField060FormatUID
				,@lActive
				,@lDeleted
				,@lApproved
				,@lAdded
				,@nAddFacilityUID
				,@nAddUserUID
				,@nImportUID
				,GetUTCDate()
				,@nAddUserUID
				,@nAddFacilityUID
				,GetUTCDate()
				,GetUTCDate()
			)
		END
		'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF EXISTS( SELECT * FROM sysobjects WHERE type='P' AND name='InsertPointReading' )
		BEGIN
			PRINT N'Dropping [dbo].[InsertPointReading]'

			DROP PROCEDURE [dbo].[InsertPointReading]

			IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END

	IF OBJECT_ID(N'[dbo].[InsertPointReading]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[InsertPointReading]'

		EXEC sp_executesql N'
		CREATE PROCEDURE [dbo].[InsertPointReading]
			 @nPointReadingUID [uniqueidentifier]
			,@nPointUID uniqueidentifier
			,@nAssetUID uniqueidentifier
			,@nReadingUnitUID uniqueidentifier  = NULL
			,@nReadingFormatUID uniqueidentifier  = NULL
			,@tReadingDateTime datetime  = NULL
			,@nReadingOrdinal int  = NULL
			,@nReading float  = NULL
			,@cReadingUnit nvarchar(50)  = NULL
			,@cReadingLabel nvarchar(50)  = NULL
			,@cReadingType nvarchar(50)  = NULL
			,@lActive int  = -1
			,@lDeleted int  = 0
			,@lApproved int  = 0
			,@lAdded int  = -1
			,@nAddFacilityUID uniqueidentifier  = ''AB9B7878-B72C-4A72-9273-47030571BE4C''
			,@nAddUserUID uniqueidentifier  = ''ABF8F215-1980-4E47-84DA-305699ECF5D5''
			,@nImportUID uniqueidentifier  = NULL
		AS
		BEGIN
			INSERT INTO [dbo].[PointReadings] (
				 [nPointReadingUID]
				,[nPointUID]
				,[nAssetUID]
				,[nReadingUnitUID]
				,[nReadingFormatUID]
				,[tReadingDateTime]
				,[nReadingOrdinal]
				,[nReading]
				,[cReadingUnit]
				,[cReadingLabel]
				,[cReadingType]
				,[lActive]
				,[lDeleted]
				,[lApproved]
				,[lAdded]
				,[nAddFacilityUID]
				,[nAddUserUID]
				,[nImportUID]
				,[tAddTime]
				,[nUpdateUserUID]
				,[nUpdateFacilityUID]
				,[tUpdateTime]
				,[tMobileTime]
			)
			VALUES (
		         @nPointReadingUID
				,@nPointUID
				,@nAssetUID
				,@nReadingUnitUID
				,@nReadingFormatUID
				,@tReadingDateTime
				,@nReadingOrdinal
				,@nReading
				,@cReadingUnit
				,@cReadingLabel
				,@cReadingType
				,@lActive
				,@lDeleted
				,@lApproved
				,@lAdded
				,@nAddFacilityUID
				,@nAddUserUID
				,@nImportUID
				,GetUTCDate()
				,@nAddUserUID
				,@nAddFacilityUID
				,GetUTCDate()
				,GetUTCDate()
			)
		END
		'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END


	PRINT N'Updating database version'
	INSERT INTO [dbo].[Version] (
		[nVersionUID]
		,[cVersion]
		,[tInstallDate]
		,[mNote]
		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
		,[tSystemUpdateTime]
	  )
	  VALUES
	  (
		'08E5DA6E-DE5E-4CFB-B024-842BDAA19FAA'
		,'3.1.0'
		,'20200316 12:12:12.000'
		,'3.1.0 Release'
		,-1
		,0
		,0
		,0
		,'DBA97ADF-F868-459D-8343-DE1DF0FFB398'
		,'915F9722-3175-4E4D-A571-4A478E8E5172'
		,'20200316 12:12:12.000'
		,'DBA97ADF-F868-459D-8343-DE1DF0FFB398'
		,'915F9722-3175-4E4D-A571-4A478E8E5172'
		,'20200316 12:12:12.000'
		,'20200316 12:12:12.000'
		,NULL
	  )

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	-- Make sure previous version records are inactive
	UPDATE [dbo].[Version] SET lActive = 0, tUpdateTime = '20200316 12:12:12.000', tMobileTime = '20200316 12:12:12.000' WHERE lActive <> 0 AND nVersionUID <> '08E5DA6E-DE5E-4CFB-B024-842BDAA19FAA'

	IF EXISTS (SELECT * FROM #tmpErrors) ROLLBACK TRANSACTION

	IF @@TRANCOUNT>0 BEGIN
	PRINT 'The database update succeeded'
	COMMIT TRANSACTION
	END
	ELSE PRINT 'The database update failed'

	DROP TABLE #tmpErrors
END
ELSE
	Print N'The database is up-to-date, version 3.1.0'
GO
